//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : IAP.h
// Description: IAP 讀寫子程序
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#ifndef _IAP_H__
#define _IAP_H__
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 共用函數 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


u8 fun_enable_fwen(void);
u16 fun_read_word(unsigned int flash_addr);
void fun_erase_page(unsigned int flash_addr);
void fun_write_data(unsigned int flash_addr,unsigned char flash_wlength,u8 *Lu8v_data);
void	IAP_NEXT_MEM_DAAR(u8	LU8V_IAP_USER_NUM);
void	IAP_Previous_Mem_Addr(u8	LU8V_IAP_USER_NUM);
u8	IAP_READ_MEN_DATA(u8 *Lu8a_IAP_Buff);
void	EEPROM_READ_MEM_ADDR(u8	LU8V_IAP_USER_NUM);
void	EEPROM_WRITE_MEM_ADDR(u8	LU8V_IAP_USER_NUM);
void	IAP_WRITE_TEST();
void	IAP_SAVE_MEMORY(u8	LU8V_IAP_USER_NUM);
void	IAP_READ_MEMORY_3_AEG(u8	LU8V_IAP_USER_NUM);
void	IAP_READ_MEMORY(u8	LU8V_IAP_USER_NUM,u8 lu8v_iap_search_num);
void	IAP_ERASE_MEMORY(u8	LU8V_IAP_USER_NUM);

extern	u8			gu8v_current_sn;
extern	u8			gu8v_search_sn;
extern	__byte_type	lu8a_iap_temp[10];


/********************************************************************
Function:	IAP
********************************************************************/
#define		WRITE_FLASH_MODE		0b10000000	//select write flash rom mode
#define		PAGE_ERASE_MODE			0b10010000	//select page erase mode	
#define		READ_FLASH_MODE			0b10110000	//select read flash rom mode & set fden=1
#define		ENABLE_FWEN_MODE		0b11100000	//select FWEN bit control mode & set bwt=1 

#define		FLASH_PAGE_SIZE			64
#define		FLASH_PAGE_BYTE			FLASH_PAGE_SIZE*2

#define		CONST_DATA_LENGTH		100			//<=128
#define		CONST_FLASH_ADDR		0x0600




//設置程序空間（K） 4 8 16 32 
#define FLASH_ROM		16	
#if FLASH_ROM ==4
	#define	LU16C_PAGE_SET_BIT	0B1111111100000000
	#define	IAP_PAGE_LENGHT		256	//word
#endif
#if FLASH_ROM ==8
	#define	LU16C_PAGE_SET_BIT	0B1111111111100000
	#define	IAP_PAGE_LENGHT		32	//word
#endif
#if FLASH_ROM ==16
	//for2260 2261 2262
//	#define	LU16C_PAGE_SET_BIT	0B1111111111000000
//	#define	IAP_PAGE_LENGHT		64	//word
	//for 2265
	#define	LU16C_PAGE_SET_BIT	0B1111111111100000
	#define	IAP_PAGE_LENGHT		32	//word
#endif
#if FLASH_ROM ==32
	#define	LU16C_PAGE_SET_BIT	0B1111111111000000
	#define	IAP_PAGE_LENGHT		64	//word
#endif


//單比數據的長度
#define	IAP_WRITE_WORD_LENGHT	4//word
#define	IAP_WRITE_BYTE_LENGHT	(IAP_WRITE_WORD_LENGHT*2)//word

//寫數據的筆數
#define	IAP_SAVE_TOTAL_LENGHT	99//word

//寫數據總長度（word）
#define	IAP_SAVE_WORD_LENGHT	(IAP_SAVE_TOTAL_LENGHT*IAP_WRITE_WORD_LENGHT)//word


//用戶個數
#define	IAP_USER_LENGHT			4//word




//數據總產度
#if (IAP_SAVE_WORD_LENGHT%IAP_PAGE_LENGHT)!=0
	#define	IAP_WRITE_PAGE_LENGHT 	((IAP_SAVE_WORD_LENGHT/IAP_PAGE_LENGHT)+2)
#else	
	#define	IAP_WRITE_PAGE_LENGHT 	((IAP_SAVE_WORD_LENGHT/IAP_PAGE_LENGHT)+1)
#endif

//IAP 分配地址空間
#define	IAP_WRITE_TOTAL_LENGHT	IAP_WRITE_PAGE_LENGHT*IAP_PAGE_LENGHT


//初始化地址	根據不同的空間page初始長度不一樣
#define	IAP_START_ADDR			(0x2000- (IAP_WRITE_TOTAL_LENGHT*IAP_USER_LENGHT))

#endif
